package com.androidbook.pettracker2;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;

import com.androidbook.pettracker2.PetTrackerDatabase.PetType;
import com.androidbook.pettracker2.PetTrackerDatabase.Pets;

public class PetTrackerListActivity extends PetTrackerActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		
		super.onCreate(savedInstanceState);
		setContentView(R.layout.showpets);
		
		// Wypełnienie kontrolki ListView danymi z bazy.
		fillPetList();
		
		// Obsługa przycisku dodania zwierzaka.
		final Button gotoEntry = (Button) findViewById(R.id.ButtonEnterMorePets);
		gotoEntry.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				// Jesteśmy gotowi. Kończymy i wracamy do ekranu początkowego.
				finish();
			}
		});
	}
	
	public void fillPetList()
	{
		// Zapytanie SQL
		SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
		queryBuilder.setTables(Pets.PETS_TABLE_NAME +", " +PetType.PETTYPE_TABLE_NAME);
		queryBuilder.appendWhere(Pets.PETS_TABLE_NAME + "." + Pets.PET_TYPE_ID + "=" + PetType.PETTYPE_TABLE_NAME + "." + PetType._ID);

		// Pobranie bazy danych i wykonanie zapytania.
        String asColumnsToReturn[] = { Pets.PETS_TABLE_NAME + "." + Pets.PET_NAME, Pets.PETS_TABLE_NAME + "." + Pets._ID, PetType.PETTYPE_TABLE_NAME + "." +PetType.PET_TYPE_NAME };
        mCursor = queryBuilder.query(mDB, asColumnsToReturn, null, null, null, null, Pets.DEFAULT_SORT_ORDER);

        // Użycie adaptera do powiązania danych z kontrolką ListView, w której każdy element jest prezentowany
        // przy wykorzystaniu układu pet_item (pet_item.xml).		
        startManagingCursor(mCursor);
        ListAdapter adapter =
            new SimpleCursorAdapter(
                this,
                R.layout.pet_item,
                mCursor,
                new String[]
                {
                	Pets.PET_NAME, PetType.PET_TYPE_NAME },
                new int[]
                {
                    R.id.TextView_PetName, R.id.TextView_PetType });
 
        ListView av = (ListView)findViewById(R.id.petList);
        av.setAdapter(adapter);
  
        av.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            public void onItemClick(
                AdapterView<?> parent, View view, int position, long id) {
            	// Sprawdzenie przycisku usuwania.
            	final long deletePetId =  id;
            	
            	// Używamy okna dialogowego AlertDialog, by potwierdzić chęć usunięcia zwierzaka.
				new AlertDialog.Builder(PetTrackerListActivity.this).setMessage(
				"Czy usunąć rekord zwierzaka?").setPositiveButton(
				"Usuń", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int which) {
						
						// Usuwamy zwierzaka.
                		deletePet(deletePetId);	

                		// Odświeżenie danych w kursorze, a zatem także w kontrolce listy.
                		mCursor.requery();
                	}
        		}).show();
            }
        });
	}
	
	public void deletePet(Long id)
	{
		String astrArgs[] = { id.toString() };
		mDB.delete(Pets.PETS_TABLE_NAME, Pets._ID + "=?",astrArgs );		
	}

}
